<?php
/**
* Getting Started
* 
* @package cf7skins
* @author Neil Murray
* @since 1.2
*/
?>
<div class="cf7s-info">
<h2>Quick Start Guide</h2>
<img src="<?php echo CF7SKINS_URL; ?>images/cf7skins-forms.jpg" alt="cf7skins-forms" width="400" height="320" class="alignright" /><p><a href="http://cf7skins.com"  target="_blank"><strong>CF7 Skins</strong></a> makes it easier for regular WordPress users to create forms using built in <strong>Templates</strong> and <strong>Styles</strong>.</p>

<p>Simply select from a list of compatible <strong>Templates</strong> that cover many common forms and then choose from a range of professional and beautiful <strong>Styles</strong>.</p>

<p>Each <strong>Template</strong> acts as an easy to follow guide, which can be adapted to your particular requirements. Every <strong>Style</strong> covers the full range of Contact Form 7 form elements.</p>

<h3>Using CF7 Skins</h3>
<p>CF7 Skins appears in an extra <strong>Skins</strong> section in the Contact Form 7 form interface. Click on <strong>Contact</strong> in the WordPress admin menu and select an existing Contact Form 7 form or create a new one, then scroll down to the <strong>Skins</strong> section.</p>

<p>The <strong>Template</strong> tab displays the available templates. Click on <strong>Details</strong> below each template to show more information. Click on <strong>Select</strong> to apply this template in the Form editing area, where you can adjust the fields to match your requirements.</p>

<p>Click on the <strong>Style</strong> tab to view the list of available styles to choose from. <strong>Details</strong> below each style gives more information about each style. Find a style that you like and click <strong>Select</strong>. Then press <strong>Save</strong> to apply the style to your form.</p>

<h3>Doing more with CF7 Skins</h3>
<img src="<?php echo CF7SKINS_URL; ?>images/using-cf7skins.jpg" alt="cf7skins-forms" width="400" height="200" class="alignright" /><p>The CF7 Skins Knowledge Base can help you get more out of using CF7 Skins with your Contact Form 7 forms.</p>

<ul>
	<li>
	<a href="http://kb.cf7skins.com/understanding-templates-and-styles/"  target="_blank">Understanding Templates and Styles</a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/why-we-use-fieldset-legend-lists-in-cf7-skins/"  target="_blank">Fieldset, Legend & Lists in CF7 Skins</a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/edit-your-cf7-skins-form/"  target="_blank">Edit your CF7 Skins Form</a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/use-custom-css-plugin/"  target="_blank">Modify your CF7 Skins Style</a>
	</li>
</ul>

<p><a class="cf7s-btn" target="_blank" href="http://kb.cf7skins.com/category/using-cf7skins/">Learn More</a></p>

<h3>Documentation</h3>
<img src="<?php echo CF7SKINS_URL; ?>images/cf7skins-solution.jpg" alt="cf7skins-forms" width="400" height="200" class="alignright size-medium wp-image-2919" /><p>Our in-depth documentation is a great place to find detailed answers.</p>

<ul>
	<li>
	<strong><a href="http://docs.cf7skins.com/"  target="_blank">Documentation</a></strong> - covers from how to get started up to how to customize your forms and everything else in between.
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/"  target="_blank">Knowledge Base</a></strong> - you can search by Categories & Tags or Keywords.
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank">Tutorials</a></strong> -  to help you get started using CF7 Skins quickly & easily.
	</li>
</ul>

<p><a href="http://cf7skins.com"  target="_blank">Plugin Website</a> | <a href="http://cf7skins.com/pro-version/"  target="_blank">Pro Version</a> | <a href="http://cf7skins.com/add-ons/"  target="_blank">Add-ons</a></p>

<p><a href="http://kb.cf7skins.com/faq/"  target="_blank">FAQ</a> | <a href="http://docs.cf7skins.com/"  target="_blank">Documentation</a> | <a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank">Tutorials</a> | <a href="http://kb.cf7skins.com/"  target="_blank">Knowledge Base</a></p>
</div>

<div class="cf7s-info-sidebar">
<h2>Do you enjoy using this plugin?</h2>
<p>You can help fellow WordPress users in the following simple ways:</p>
<ul>
	<li>
	<strong><a href="https://wordpress.org/support/view/plugin-reviews/contact-form-7-skins"  target="_blank">Review</a></strong> - leave a  plugin review on WordPress.org
	</li>
	<li>
	<strong><a href="http://cf7skins.com/pro-version/testimonials/"  target="_blank">Testimonial</a></strong> - add your Testimonial to those listed
	</li>
	<li>
	<strong><a href="https://wordpress.org/plugins/contact-form-7-skins/"  target="_blank">Compatibility</a></strong> - log in & vote "works" on your current versions
	</li>
	<li>
	<strong><a href="http://cf7skins.com/support/#feedback"  target="_blank">Feedback</a></strong> - help us to improve CF7 Skins by offering feedback
	</li>
</ul>

<h2>Need some help?</h2>
<p>You have a number of options to help you use CF7 Skins:</p>
<ul>
	<li>
	<strong><a href="http://kb.cf7skins.com/faq/"  target="_blank">FAQ</a></strong> - browse over some commonly asked questions.
	</li>
	<li>
	<strong><a href="http://docs.cf7skins.com/"  target="_blank">Documentation</a></strong> - a great place to find detailed answers.
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/"  target="_blank">Knowledge Base</a></strong> - search by Categories & Tags or Keywords.
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank">Tutorials</a></strong> - to help you get started quickly with CF7 Skins.
	</li>
	<li><strong>Free Version</strong></li>
	<ul>
		<li>
		<strong><a href="https://wordpress.org/support/plugin/contact-form-7-skins"  target="_blank">WordPress.org Support Forum</a></strong> - community based support offered by other CF7 Skin users (we visit the forum intermittently to assist with plugin bugs only).
		</li>
	</ul>
	<li><strong>Pro Version & Add-ons</strong></li>
	<ul>
		<li>
		<strong><a href="http://cf7skins.com/support/#premium-email-support"  target="_blank">Premium Email Support</a></strong> - available (for current paid licenses) to deal with CF7 Skins Pro users questions and problems.
		</li>
	</ul>
</ul>
<p><a href="http://cf7skins.com"  target="_blank">Plugin Website</a> | <a href="http://cf7skins.com/pro-version/"  target="_blank">Pro Version</a> | <a href="http://cf7skins.com/add-ons/"  target="_blank">Add-ons</a></p>

<p><a href="http://kb.cf7skins.com/faq/"  target="_blank">FAQ</a> | <a href="http://docs.cf7skins.com/"  target="_blank">Documentation</a> | <a href="http://kb.cf7skins.com/category/tutorials/"  target="_blank">Tutorials</a> | <a href="http://kb.cf7skins.com/"  target="_blank">Knowledge Base</a></p>
</div>