@extends('templates.page-template')

@section('title', 'Tax Advisory Services in Sri Lanka')

@section('content')

<section class="service-facilites mt-2 pt-2 pb-0">
    <div class="auto-container">
        <div class="row">

            <!-- Main Title & Introduction -->
            <div class="col-xl-12 col-lg-12 col-sm-12">
                <div class="sec-title center wow fadeInUp pb-0 mb-0 mt-4" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Tax Advisory Services in <span>Sri Lanka</span></h2>
                    <p><strong>Navigate Sri Lanka’s Dynamic Tax Landscape with Confidence</strong></p>
                    <p>Sri Lanka’s tax environment has become increasingly complex, with frequent legislative updates and a renewed focus on compliance by the authorities. Effective tax planning, precise preparation, and proactive advice are vital for businesses and individuals to remain compliant, optimize tax liabilities, and avoid penalties.</p>
                    <p>At DXP Associates, our experienced Sri Lankan tax consultants provide comprehensive advisory and compliance solutions that support your business goals while ensuring full compliance with local regulations.</p>
                </div>
            </div>

            <!-- Our Tax Services Section -->
            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4">
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms" style="margin-top: 40px;">
                    <h2>Our Tax Services for the <span>Sri Lankan Market</span></h2>
                </div>
                <!-- Services arranged in a two-column layout -->
                <div class="row sp-service-facilites">
                   <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Registration with the Inland Revenue Department (IRD)</a></h2>
                            <p>Guidance and facilitation for Taxpayer Identification Number (TIN) registration for companies, partnerships, and individuals. Support with e-tax registration and onboarding onto the Inland Revenue Department’s digital platforms.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Corporate Tax Compliance & Planning</a></h2>
                            <p>Timely preparation and filing of corporate income tax returns in compliance with the Sri Lankan Inland Revenue Act. Industry-specific tax planning to reduce exposure to new rules such as changes to VAT, ESC, or SSCL. Maximizing allowable deductions, utilization of losses, and application of double tax treaties where eligible.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Tax Authority Representation</a></h2>
                            <p>Representation at the Inland Revenue Department during audits, assessments, and appeals. Expert handling of queries, correspondences, and all statutory notices from Sri Lankan tax authorities.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Personal Income Tax Services</a></h2>
                            <p>Comprehensive preparation, filing, and optimization for individual tax returns, including PAYE, capital gains, and investment income. Strategic personal tax planning with updates on changing tax brackets, reliefs, and potential liabilities.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">VAT, NBT, SSCL, & Other Indirect Tax Advisory</a></h2>
                            <p>Registration, ongoing compliance, and returns filing for Value Added Tax (VAT), Social Security Contribution Levy (SSCL), and other indirect taxes. Structuring advice for transactions, ensuring compliance and efficient tax outcomes.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Payroll & Employment Tax Advisory</a></h2>
                            <p>Support on calculation and remittance of PAYE tax, contributions to EPF/ETF, and the Employee Trust Fund. Compliance with the latest employment tax rates, reliefs, and employee benefit taxation per Sri Lanka’s annual budget changes.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Tax Planning & Compliance Reviews</a></h2>
                            <p>Annual and quarterly tax reviews to keep your organization updated on emerging risks and new compliance standards. Scenario analysis to prepare for changes such as digital services tax or tax amnesty programs, as announced in the latest Sri Lankan budgets.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Cross-Border & International Tax Advisory</a></h2>
                            <p>Advisory on transfer pricing, double taxation avoidance agreements (DTAA), and structuring of cross-border transactions for multinational and Sri Lankan companies with overseas operations.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Tax Incentives & Grant Advisory</a></h2>
                            <p>Identification and facilitation of tax exemptions, BOI concessions, and government incentive programs available for startups, exporters, and priority sectors under Sri Lankan investment laws.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Why Choose Us Section -->
            <div class="col-xl-12 col-lg-12 col-sm-12 mt-5">
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Why Choose Us for <span>Sri Lankan Tax Advisory?</span></h2>
                </div>
                <div class="row sp-service-facilites">
                    <div class="col-xl-3 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Up-to-Date Local Knowledge</a></h2>
                            <p>Our advisors are constantly trained on Sri Lankan Inland Revenue changes, keeping you ahead of regulatory shifts.</p>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Personalized Tax Strategies</a></h2>
                            <p>Solutions are tailored to your sector, business structure, and future plans.</p>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Comprehensive Support</a></h2>
                            <p>From day-to-day compliance to complex IRD audits, we are with you at every stage.</p>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Proactive Education</a></h2>
                            <p>We inform clients of all upcoming tax reforms and legal amendments affecting Sri Lankan taxpayers.</p>
                        </div>
                    </div>
                </div>       
            </div>

            <!-- Call to Action -->
            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4" style="background-color: #f8f9fa; padding: 40px; border-radius: 8px;">
                 <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Stay Compliant and <span>Optimize Your Taxes</span> in Sri Lanka</h2>
                    <p class="mt-3">Contact us today for a personalized consultation and discover how our experts can help you navigate Sri Lanka’s evolving tax landscape with seamless, compliant, and efficient tax management solutions.</p>
                    <div class="btn-box">
                        <a href="/contact-us" class="theme-btn btn-style-one">
                            <span class="btn-title">Contact Us</span>
                        </a>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

@endsection