@extends('templates.page-template')

@section('title', 'Expert Bookkeeping & Accounting Services Tailored to Your Business')

@section('content')

<section class="service-facilites mt-2 pt-2 pb-0">
    <div class="auto-container">
        <div class="row">

            <!-- Main Title & Introduction -->
            <div class="col-xl-12 col-lg-12 col-sm-12">
                <div class="sec-title center wow fadeInUp pb-0 mb-0 mt-4" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Outsourced Internal Audit Services</h2>
                    <p><strong>Proactive, Value-Driven Internal Audit Solutions for Forward-Thinking Businesses</strong></p>
                    <p>At DXP Associates, we recognize the pressure on Sri Lankan businesses—large and small—to maintain robust internal controls, operate efficiently, and meet increasingly complex regulatory requirements. Our outsourced Internal Audit Services are designed to give you the agility, insight, and assurance needed to thrive in today's dynamic environment.</p>
                </div>
            </div>

            <!-- Why Choose DXP Associates Section -->
            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4">
                 <div class="sec-title center wow fadeInUp pb-0 mb-0" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Why Choose DXP Associates for <span>Internal Audit?</span></h2>
                </div>
                <div class="row sp-service-facilites">
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Expertise You Can Trust</a></h2>
                            <p>Our team comprises certified internal audit professionals with deep knowledge of Sri Lankan regulations, industry risks, and best practices.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Flexible Engagement Models</a></h2>
                            <p>Whether you need complete outsourcing, co-sourcing, help with special projects, or temporary resources, we design services that fit your exact needs.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Continuous Value Creation</a></h2>
                            <p>We build long-term partnerships focused on improvement, not just compliance. Our internal auditors work collaboratively with you throughout the year.</p>
                        </div>
                    </div>
                </div>
                
            </div>

            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4">
                <div class="sec-title center wow fadeInUp mb-0" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>How Our Internal Audit Services <span>Empower Business Owners</span></h2>
                </div>
                <div class="row sp-service-facilites">
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Unbiased Control Assessments</a></h2>
                            <p>Gain independent assurance on your risk management, governance, and internal controls, minimizing the risk of financial loss, fraud, and regulatory breaches.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Efficiency & Effectiveness</a></h2>
                            <p>Our operational reviews help streamline processes, cut unnecessary costs, and make your business more agile.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Strategic Advisory</a></h2>
                            <p>Through ongoing communication, we proactively identify emerging issues and help you adapt to new business and regulatory challenges.</p>
                        </div>
                    </div>
                </div>                
            </div>

            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4">
                <div class="sec-title center wow fadeInUp mt-0" data-wow-delay="200ms" data-wow-duration="1200ms" style="margin-top: 40px;">
                    <h2>Our Internal Audit <span>Methodology</span></h2>
                    <p>Our approach is systematic, disciplined, and technology-driven. Each engagement typically includes:</p>
                </div>
                <div class="row sp-service-facilites">
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Dynamic Risk Assessment & Planning</a></h2>
                            <p>We tailor the engagement to your latest risk environment, utilizing AI-powered analytics to detect hidden trends.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Hands-On Project Planning</a></h2>
                            <p>We collaborate with your management to define objectives, audit scope, and communication timelines.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Meetings & Process Walkthroughs</a></h2>
                            <p>Our auditors conduct interviews and walkthroughs, mapping out your organization's unique processes.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Custom Audit Program Design</a></h2>
                            <p>We build or adapt audit procedures to fit your sector, incorporating automated sampling and AI-driven analysis.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Fieldwork & Testing</a></h2>
                            <p>Both manual and AI-assisted reviews are conducted for comprehensive coverage and faster detection of weaknesses.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Regular Updates & Issue Reviews</a></h2>
                            <p>We keep you informed of preliminary findings, so you are never caught off guard.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Comprehensive Reporting</a></h2>
                            <p>Final reports include actionable recommendations prioritized by risk and potential impact.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Follow-Up on Previous Issues</a></h2>
                            <p>We monitor the implementation of recommendations and provide ongoing improvement insights.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Types of Internal Audit Services Section -->
            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4">
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Types of Internal Audit <span>Services We Offer</span></h2>
                </div>
                <div class="row" style="text-align: left; max-width: 900px; margin: auto;">
                    <div class="col-md-6">
                        <ul>
                            <li><i class="fa fa-check"></i> Full Outsourcing / Co-Sourcing</li>
                            <li><i class="fa fa-check"></i> Special Projects & Advisory</li>
                            <li><i class="fa fa-check"></i> Operational Audits</li>
                            <li><i class="fa fa-check"></i> Internal Controls Review & Solutions</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul>
                            <li><i class="fa fa-check"></i> Enterprise Risk Management & Governance</li>
                            <li><i class="fa fa-check"></i> IT Governance & Cybersecurity Audits</li>
                            <li><i class="fa fa-check"></i> Forensic Investigations</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Transforming with AI Section -->
             <div class="col-xl-12 col-lg-12 col-sm-12 mt-5">
                 <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Transforming Internal Audit <span>with AI</span></h2>
                    <p>Modern internal audit leverages artificial intelligence to speed up transaction testing, identify hidden risks, enable continuous monitoring, and even predict potential control failures. At DXP Associates, we integrate AI tools and advanced audit analytics into our methodology, giving your business unmatched insight and resilience.</p>
                </div>
            </div>

            <!-- Call to Action -->
            <div class="col-xl-12 col-lg-12 col-sm-12 m-0 p-0" style="background-color: #f8f9fa; padding: 40px; border-radius: 8px;">
                 <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Enhance <span>confidence, streamline compliance</span>, and stay ahead of risks.</h2>
                    <p class="mt-3">Partner with DXP Associates for internal audit services tailored for the challenges of today’s Sri Lankan business environment.</p>
                    <div class="btn-box">
                        <a href="/contact-us" class="theme-btn btn-style-one">
                            <span class="btn-title">Contact Us</span>
                        </a>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

@endsection