@php
    use Illuminate\Support\Facades\File;

    $jsonPath = public_path('/json/home-services.json'); 
    $json = File::get($jsonPath);
    $data = json_decode($json, true);

    $services = collect($data['services'])->sortBy('order')->values()->all();
@endphp

@foreach($services as $service)
    <li>
        <a href="{{ $service['link'] }}">
            <h3 class="title">{{ $service['title'] }}</h3>
            <span class="icon"><i class="fas fa-angle-double-right"></i> </span>
        </a>
    </li>
@endforeach