@extends('templates.page-template')

@section('title', 'Contact Us')

@section('content')

<section class="contact-info style-two">
    	<div class="auto-container">
    		<div class="full-content wow fadeInUp" data-wow-delay="700ms" data-wow-duration="1200ms" style="background:#fff;">
    			<div class="row">
    				<div class="col-xl-6 col-lg-12 col-sm-12">
						<div class="contact">
							<div class="sec-title mb-0 pb-0">
								<h2>Contact <span>Information</span></h2>
							</div>
							<div class="row">
								<div class="info-column col-lg-12">
									<div class="icon-box">
										<div class="icon"><span class="fas fa-envelope"></span></div>
										<h3>E-Mail</h3>
										<ul>
											<li>info@dxpassociates.com</li>
										</ul>
									</div>
								</div>
								<div class="info-column col-lg-12">
									<div class="icon-box">
										<div class="icon"><span class="fas fa-map-marker-alt"></span></div>
										<h3>Office Address</h3>
										<ul>
											<li>Level 12-13, MAGA ONE, No. 200 Narahenpita Road, Colombo 05, Sri Lanka</li>
										</ul>
									</div>
								</div>
								<div class="info-column col-lg-12">
									<div class="icon-box">
										<div class="icon"><span class="fas fa-phone"></span></div>
										<h3>Call Us Now</h3>
										<ul>
											<li><a href="tel:+94775308036">+947 753 080 36</a></li>
										</ul>
									</div>
								</div>
                                <div class="info-column col-lg-12">
									<div class="icon-box">
										<div class="icon"><span class="fab fa-whatsapp"></span></div>
										<h3>Call Us Now</h3>
										<ul>
											<li><a href="https://api.whatsapp.com/send?phone=94765353213"><i class="fab fa-whatsapp"></i> +94 765 353 213</a></li>
										</ul>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-xl-6 col-lg-12 col-sm-12">
						<!-- Contact Form-->
						<div class="contact-form">
							<div class="sec-title mb-0 pb-0">
								<h2>Type <span>Message</span></h2>
							</div>
							<form method="post" action="/contact-us" id="contact-form">
								@csrf
								<div class="row clearfix">                                    
									<div class="col-md-6 form-group">
										<input type="text" name="name" id="name" placeholder="Your Full Name*" required="">
										<i class="fas fa-user"></i>
									</div>

									<div class="col-md-6 form-group">
										<input type="email" name="email" id="email" placeholder="Your Emai*" required="">
										<i class="fas fa-envelope"></i>
									</div>

									<div class="col-md-12 form-group">
										<select class="selectpicker" name="service">
											<option value="Accounting Book Keeping Solutions">Accounting & Book Keeping Solutions</option>
                                            <option value="Quickbooks Services">QuickBooks Services</option>
                                            <option value="Audit Assurance Services">Audit & Assurance Services</option>
                                            <option value="Tax Advisory Services">Tax Advisory Services</option>
                                            <option value="Business and Financial Consulting">Business and Financial Consulting</option>
                                            <option value="Company Incorporation Services">Company Incorporation Services</option>
                                            <option value="Outsourced Internal Audit Services">Outsourced Internal Audit Services</option>
                                            <option value="Cloud Accounting">Cloud Accounting Services</option>
                                            <option value="Accounting BPO Services">Accounting BPO Services</option>
											<option value="Advisory 360">Advisory 360</option>
										</select>
										<i class="fas fa-cog"></i>
									</div>
									
									<div class="col-md-6 form-group">
										<input type="text" name="phone_number" id="phone_number" placeholder="Phone Number">
										<i class="fas fa-phone"></i>
									</div>

									<div class="col-md-6 form-group">
										<input type="text" name="company_name" id="company_name" placeholder="Company Name">
										<i class="fas fa-building"></i>
									</div>

									<div class="col-md-12 form-group" style="display: none;">
										<select class="selectpicker" name="consultation_mode" id="consultation_mode">
											<option value="N/A">N/A</option>
										</select>
										<i class="fas fa-user"></i>
									</div>

									<div class="col-md-12 form-group">
										<input type="text" name="country" id="country" placeholder="Country">
										<i class="fas fa-globe"></i>
									</div>
									
									<div class="col-md-12 form-group">
										<textarea name="message_text" id="message_text" placeholder="Message" rows="5" cols="40" required></textarea>
										<i class="fa fa-file-edit"></i>
									</div>
									
									<div class="col-md-12 form-group">
										{{-- Check for a 'success' message --}}
										@if (session('success'))
											<div class="alert alert-success">
												{{ session('success') }}
											</div>
										@endif

										{{-- Check for an 'error' message --}}
										@if (session('error'))
											<div class="alert alert-danger">
												{{ session('error') }}
											</div>
										@endif

										@if ($errors->has('g-recaptcha-response'))
											<span class="text-danger">{{ $errors->first('g-recaptcha-response') }}</span>
										@endif
									</div>

									<div class="col-md-12 form-group">
										{!! NoCaptcha::display() !!}
										@error('g-recaptcha-response')
											<small style="color:red">{{ $message }}</small>
										@enderror
									</div>

									<div class="col-md-12 form-group">
										<button class="theme-btn btn-style-one" type="submit" name="submit-form"><span class="btn-title">Contact Us</span></button>
									</div>
								</div>

								 
							</form>
						</div>
					</div>
    			</div>
    		</div>
    	</div>
    </section>

@endsection