@extends('templates.page-template')

@section('title', 'Cloud Accounting')

@php
    $wrapper_img = "assets/images/wrappers/quickbooks-services.jpg"
@endphp

@section('content')

<section class="service-facilites mt-2 pt-2 pb-0">
    <div class="auto-container">
        <div class="row">

            <div class="col-xl-12 col-lg-12 col-sm-12">
                <div class="sec-title center wow fadeInUp pb-0 mb-0 mt-4" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Cloud Bookkeeping Services | <span>Affordable Online Accounting Packages</span></h2>
                    <p>Simplify your business finances and save up to 60% with secure, easy-to-use cloud bookkeeping solutions. Access your accounting anytime and make compliance stress-free—perfect for freelancers, small businesses, and growing enterprises.</p>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-sm-12 mt-5">
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Why Choose <span>Cloud Accounting?</span></h2>
                </div>
                <div class="row sp-service-facilites">
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Simplicity & Real-Time Accessibility</a></h2>
                            <p>Seamlessly transfer your current financial data to leading cloud-based accounting platforms like QuickBooks and Xero. Access your real-time business transactions on any device—including PC, Mac, tablet, or smartphone—from anywhere, anytime. Instantly collaborate and manage your financials with just a press of a button.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Affordable & Efficient Bookkeeping</a></h2>
                            <p>No upfront investment in hardware or software—subscribe for a predictable, low monthly fee. Eliminate the costs of hiring on-site bookkeepers with expert remote accounting services. Automate time-consuming tasks such as invoicing, reconciliation, and compliance.</p>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <h2><a href="#">Secure Data & Hassle-Free Collaboration</a></h2>
                            <p>All financial data is encrypted, stored, and backed up automatically, so you never have to worry about data loss. Share vital business information securely with partners and accountants in real time—no location limits. Stay audit-ready and always compliant with automated software updates.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4">
                <div class="sec-title center wow fadeInUp m-0 p-0" data-wow-delay="200ms" data-wow-duration="1200ms" style="margin-top: 40px;">
                    <h2>Our Cloud <span>Bookkeeping Packages</span></h2>
                </div>
                <div style="overflow-x: auto;">
                    <table class="table table-bordered table-striped" style="width: 100%; min-width: 750px; margin-top: 20px;">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">Package</th>
                                <th scope="col">Monthly Fee</th>
                                <th scope="col">Best For</th>
                                <th scope="col">Key Features</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><strong>SOLO</strong></td>
                                <td>LKR 20,000</td>
                                <td>Freelancers, Micro-businesses</td>
                                <td>1-year QuickBooks Online subscription, initial setup, monthly bookkeeping, bank reconciliation, basic tax compliance, basic reports, quarterly business review, support</td>
                            </tr>
                            <tr>
                                <td><strong>ENTREPRENEUR</strong></td>
                                <td>LKR 35,000</td>
                                <td>Small Businesses, Start-ups</td>
                                <td>1-year QB subscription, setup & training, weekly bookkeeping, full management accounts with KPIs, monthly review, audit support.</td>
                            </tr>
                            <tr>
                                <td><strong>BUSINESS</strong></td>
                                <td>LKR 55,000</td>
                                <td>Established Small-Medium Businesses</td>
                                <td>1-year QB subscription, setup & training, daily bookkeeping, unlimited tax consulting, annual tax planning, weekly KPI reports, payroll, budgeting, onsite support, audit support</td>
                            </tr>
                            <tr>
                                <td><strong>ENTERPRISE</strong></td>
                                <td>Custom Quote</td>
                                <td>Medium-Large Businesses (Complex)</td>
                                <td>Custom solutions for companies with advanced or unique needs—build your own package, request tailored advice</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-sm-12 mt-5">
                 <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Why Leading Businesses <span>Trust Cloud Accounting</span></h2>
                    <ul style="text-align: center; padding-left: 20px; list-style-type: '✔ ';">
                        <li><i class="fa fa-check"></i> Save up to 60% on bookkeeping costs</li>
                        <li><i class="fa fa-check"></i> Get real-time insights into cash flow, profits, and KPIs</li>
                        <li><i class="fa fa-check"></i> Automated compliance and backup keep you protected</li>
                        <li><i class="fa fa-check"></i> Seamless sharing and collaboration for distributed or remote teams</li>
                    </ul>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-sm-12 mt-4 mb-4">
                <div class="sec-title center wow fadeInUp pb-0 mb-0" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2><span>Cloud Accounting</span> Software Integration:</h2>
                    <p>We support all major cloud-based accounting platforms for real-time access and secure data management, ensuring your business operates efficiently from anywhere.</p>    
                </div>
                <div style="width: 65%; margin:0px auto;">
                    <img src="assets/images/partners.png" alt="Our Partners" width="100%">
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-sm-12 m-0 p-0" style="background-color: #f8f9fa; padding: 40px; border-radius: 8px;">
                <div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
                    <h2>Get started with <span>secure, affordable, and efficient</span> cloud bookkeeping today.</h2>
                    <p>Request your custom cloud accounting quote or choose a package to transform your business finances!</p>
                    <p class="mt-3"><em>All our services are powered by industry-leading cloud platforms, and our dedicated accountants provide professional support every step of the way.</em></p>
                    <div class="btn-box">
                        <a href="/contact-us" class="theme-btn btn-style-one">
                            <span class="btn-title">Contact Us</span>
                        </a>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

@endsection