@extends('templates.page-template')

@section('title', 'About Us')

@section('content')    
    
    <section class="about-us mt-4 mb-4">
    	<div class="auto-container">
    		<div class="row">
    			<div class="col-xl-12 col-lg-12 col-sm-12">
    				<div class="content pt-0">
    					<div class="sec-title wow fadeInUp text-center" data-wow-delay="200ms" data-wow-duration="1200ms">
							<img src="assets/images/about-us-logo.png" width="150" alt="">
    						<h3>About <span>DXP Associates</span></h3>
    						<h2><span>Who We Are</span></h2>
    						<p class="pb-2">DXP Associates is a leading Chartered Accountancy firm in Sri Lanka, registered with the Institute of Chartered Accountants of Sri Lanka (CA Sri Lanka). Our team is composed of highly qualified and experienced professionals dedicated to providing exceptional value and optimizing benefits for our valued clients. With a strong foundation in local and international best practices, our business-minded financial experts bring deep industry knowledge, practical insights, and a solutions-driven approach to every engagement.</p>
                            <p class="pb-2">As your accounting needs will continue to grow with your business, you need to pay careful thought to a long term and viable solution for this vital part of your business. By hiring DXP Associates to take care of all your accounting needs, you can ensure a step in the right direction. By letting us be your professional accountants, not only would you have availed the services of highly qualified, experienced professionals not commonly available at an affordable price for small businesses, you would also have more time and saved resources to run your business successfully.</p>
    					</div>
    				</div>
    			</div>
    		</div>
    	</div>
    </section>

    <section class="whychoosus-three" style="background-image: url(assets/images/background/whychoosus-three-bg.jpg);">
    	<div class="auto-container">
    		<div class="row">
    			<div class="col-xl-5 col-lg-12 col-sm-12">
    				<div class="content-box">
    					<div class="sec-title wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
							<h2>More About <span>DXP Associates</span></h2>
							<h4>We deliver industry‑leading Finance & Accounting BPO services to businesses and entrepreneurs worldwide—streamlining your accounting workflows, ensuring full compliance with regulations, and delivering clear, actionable financial insights for growth.</h4>
						</div>
    				</div>
    			</div>
    			<div class="col-xl-7 col-lg-12 col-sm-12">
    				<div class="row">
    					<div class="col-xl-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
							<div class="item">
								<div class="icon">
									<span class="flaticon-pricing"></span>
								</div>
								<h2><a href="#">Our Mission</a></h2>
								<p>Our mission is to empower clients by delivering professional, personalized attention and reliable, timely service. By upholding the highest standards of excellence and integrity, we ensure our clients are confident, compliant, and fully equipped to make informed financial decisions. We build enduring relationships based on trust, quality, and consistent results—earning the loyalty of businesses and individuals year after year.</p>
							</div>
						</div>
   						<div class="col-xl-6 col-sm-12 wow " data-wow-delay="400ms" data-wow-duration="1200ms">
							<div class="item">
								<div class="icon">
									<span class="flaticon-award"></span>
								</div>
								<h2><a href="#">Integrated Service Provider</a></h2>
								<p>As a comprehensive chartered accountancy and consulting firm, DXP Associates offers a full suite of integrated accounting and financial solutions tailored for businesses, organizations, and individuals across Sri Lanka. Our one-stop approach ensures seamless support for all your accounting, assurance, tax, and advisory needs.</p>
							</div>
						</div>
    				</div>
    			</div>
    		</div>
    	</div>
    </section>

	<section class="service-facilites pb-0">
    	<div class="auto-container">
    		<div class="sec-title center wow fadeInUp mb-0 pb-2" data-wow-delay="200ms" data-wow-duration="1200ms">
				<h2>Our <span>Related Companies</span></h2>
			</div>
   			<div class="row">
				<div class="col-xl-12 col-lg-12 col-sm-12 text-center">
					<img src="assets/images/strategic-solutions-logo.png" width="350" class="pb-4" alt="DXP Strategic Solutions">
					<p class="pb-2">DXP Strategic Solutions Private Limited is the specialized service arm of DXP Associates, providing comprehensive outsourced accounting and business solutions. We support businesses with accounting, bookkeeping, payroll management, and business deal advisory services, ensuring accuracy, compliance, and timely reporting.</p>
                	<p class="pb-2">Our services extend beyond traditional accounting to include virtual CFO support, tax and compliance advisory, process automation, system implementation, business setup, and financial analytics. This allows clients to focus on growth while we manage their financial and operational needs.</p>
					<p class="pb-2">By combining deep expertise with modern technology and strategic insights, DXP Associates and DXP Strategic Solutions Private Limited deliver end-to-end financial and business solutions that drive efficiency, growth, and long-term success.</p>
				</div>
			</div>
		</div>
	</section>


    <section class="service-facilites">
    	<div class="auto-container">
    		<div class="sec-title center wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1200ms">
				<h2>Our Core <span>Services</span></h2>
				<p>Discover our most trusted and impactful solutions designed to drive your business forward.</p>
			</div>
   			<div class="row">
                @php
                    use Illuminate\Support\Facades\File;

                    $jsonPath = public_path('/json/home-services.json'); 
                    $json = File::get($jsonPath);
                    $data = json_decode($json, true);
                    $services = collect($data['services'])->sortBy('order')->values()->all();
                @endphp

                @foreach($services as $service)
                    <div class="col-xl-4  col-lg-6 col-sm-12 wow " data-wow-delay="200ms" data-wow-duration="1200ms">
                        <div class="item">
                            <div class="icon">
                                <span class="{{ $service['icon'] }}"></span>
                            </div>
                            <h2><a href="{{ $service['link'] }}">{{ $service['title'] }}</a></h2>
                            <p>{{ $service['description'] }}</p>
                        </div>
                    </div>
                @endforeach
   			</div>
    	</div>
    </section>


@endsection
